using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
	public partial class STD_GUI_CONTROLSDB : DBUtils
	{
		#region Fields
		#endregion

		#region Constructors

		public STD_GUI_CONTROLSDB()
		{
		}

		#endregion

		#region Properties
		#endregion

		#region Methods

		public List<STD_GUI_CONTROLS> GetByCategory(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string category)
		{
			List<STD_GUI_CONTROLS> objReturn = null;

			try
			{
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_STD_GUI_CONTROLS_GetByCategory(CURRENT_USER, CURRENT_REGISTRY_ID, category).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
